/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.database.AssetsDatabase;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;

public class FallbackResourceManagerHook {
    public static final Set<String> negativeResourceCache = new HashSet<String>();
    public static final AssetsDatabase database = new AssetsDatabase();

    public static void clearCache() {
        negativeResourceCache.clear();
    }

    public static IResource getCachedResource(FallbackResourceManager manager, ResourceLocation location) throws IOException {
        if (negativeResourceCache.contains(location.toString())) {
            throw new FileNotFoundException(location.toString());
        }
        ResourceLocation mcMetaLocation = FallbackResourceManager.func_110537_b((ResourceLocation)location);
        InputStream mcMetaStream = null;
        for (int i = manager.field_110540_a.size() - 1; i >= 0; --i) {
            InputStream stream;
            InputStream safe;
            IResourcePack currentPack = (IResourcePack)manager.field_110540_a.get(i);
            if (mcMetaStream == null && (safe = FallbackResourceManagerHook.getFromFile(currentPack, mcMetaLocation)) != null) {
                mcMetaStream = safe;
            }
            if ((stream = FallbackResourceManagerHook.getFromFile(currentPack, location)) == null) continue;
            return new SimpleResource(currentPack.func_130077_b(), location, stream, mcMetaStream, manager.field_110539_b);
        }
        negativeResourceCache.add(location.func_110623_a());
        throw new FileNotFoundException(location.toString());
    }

    public static InputStream getFromFile(IResourcePack pack, ResourceLocation location) {
        try {
            return new BufferedInputStream(pack.func_110590_a(location));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        try {
            negativeResourceCache.addAll(database.getAllNegative());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

